* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Figure 7
use year dtfp RK R_frac using "$datapath/macrodata_coopimmo.dta", clear

* Create panel a)
local hmax = 10 + 1
gen innov 	= dtfp
qui su innov
gen eps = innov / r(sd)
drop innov
gen Y 	= RK * 100 
forvalues h = 0/`hmax' {
	gen Y_`h' = f`h'.Y
}
eststo clear
cap drop b u d Years Zero b_level
gen Years = _n-1 if _n<=`hmax'
gen Zero =  0    if _n<=`hmax'
gen b=0
gen u=0
gen d=0
forv h = 0/`hmax' {
	* levels
newey Y_`h' l(0).eps l(1/4).Y, lag(`h')
replace b = _b[eps]                    if _n == `h'+1
replace u = _b[eps] + 1.645* _se[eps]  if _n == `h'+1
replace d = _b[eps] - 1.645* _se[eps]  if _n == `h'+1
eststo
}
* nois esttab , se nocons keep(eps)
gen b_level = b 

* Save coefficients
gen plota_u = u
gen plota_d = d 
gen plota_b_level = b_level 



* Create panel b)
drop Y Y_*
gen Y 	= R_frac * 100 
forvalues h = 0/`hmax' {
	gen Y_`h' = f`h'.Y
}
eststo clear
cap drop b u d Years Zero b_level
gen Years = _n-1 if _n<=`hmax'
gen Zero =  0    if _n<=`hmax'
gen b=0
gen u=0
gen d=0
forv h = 0/`hmax' {
	* levels
	 newey Y_`h' l(0).eps l(1/4).Y, lag(`h')
replace b = _b[eps]                    if _n == `h'+1
replace u = _b[eps] + 1.645* _se[eps]  if _n == `h'+1
replace d = _b[eps] - 1.645* _se[eps]  if _n == `h'+1
eststo
}
* nois esttab , se nocons keep(eps)
gen b_level = b 

* Save coefficients
gen plotb_u = u
gen plotb_d = d 
gen plotb_b_level = b_level 

keep plota* plotb* Years Zero


save "$mainpath/Figures/Figures_data/Figure7.dta", replace


